this.primevue = this.primevue || {};
this.primevue.scrollpanel = this.primevue.scrollpanel || {};
this.primevue.scrollpanel.style = (function (BaseStyle) {
    'use strict';

    function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

    var BaseStyle__default = /*#__PURE__*/_interopDefaultLegacy(BaseStyle);

    var css = "\n@layer primevue {\n    .p-scrollpanel-wrapper {\n        overflow: hidden;\n        width: 100%;\n        height: 100%;\n        position: relative;\n        z-index: 1;\n        float: left;\n    }\n\n    .p-scrollpanel-content {\n        height: calc(100% + 18px);\n        width: calc(100% + 18px);\n        padding: 0 18px 18px 0;\n        position: relative;\n        overflow: auto;\n        box-sizing: border-box;\n        scrollbar-width: none;\n    }\n\n    .p-scrollpanel-content::-webkit-scrollbar {\n        display: none;\n    }\n\n    .p-scrollpanel-bar {\n        position: relative;\n        background: #c1c1c1;\n        border-radius: 3px;\n        z-index: 2;\n        cursor: pointer;\n        opacity: 0;\n        transition: opacity 0.25s linear;\n    }\n\n    .p-scrollpanel-bar-y {\n        width: 9px;\n        top: 0;\n    }\n\n    .p-scrollpanel-bar-x {\n        height: 9px;\n        bottom: 0;\n    }\n\n    .p-scrollpanel-hidden {\n        visibility: hidden;\n    }\n\n    .p-scrollpanel:hover .p-scrollpanel-bar,\n    .p-scrollpanel:active .p-scrollpanel-bar {\n        opacity: 1;\n    }\n\n    .p-scrollpanel-grabbed {\n        user-select: none;\n    }\n}\n";
    var classes = {
      root: 'p-scrollpanel p-component',
      wrapper: 'p-scrollpanel-wrapper',
      content: 'p-scrollpanel-content',
      barx: 'p-scrollpanel-bar p-scrollpanel-bar-x',
      bary: 'p-scrollpanel-bar p-scrollpanel-bar-y'
    };
    var ScrollPanelStyle = BaseStyle__default["default"].extend({
      name: 'scrollpanel',
      css: css,
      classes: classes
    });

    return ScrollPanelStyle;

})(primevue.base.style);
