'use strict';

var BaseStyle = require('primevue/base/style');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var BaseStyle__default = /*#__PURE__*/_interopDefaultLegacy(BaseStyle);

var css = "\n@layer primevue {\n    .p-rating {\n        position: relative;\n        display: flex;\n        align-items: center;\n    }\n\n    .p-rating-item {\n        display: inline-flex;\n        align-items: center;\n        cursor: pointer;\n    }\n\n    .p-rating.p-readonly .p-rating-item {\n        cursor: default;\n    }\n}\n";
var classes = {
  root: function root(_ref) {
    var props = _ref.props;
    return ['p-rating', {
      'p-readonly': props.readonly,
      'p-disabled': props.disabled
    }];
  },
  cancelItem: function cancelItem(_ref2) {
    var instance = _ref2.instance;
    return ['p-rating-item p-rating-cancel-item', {
      'p-focus': instance.focusedOptionIndex === 0 && instance.isFocusVisibleItem
    }];
  },
  cancelIcon: 'p-rating-icon p-rating-cancel',
  item: function item(_ref3) {
    var instance = _ref3.instance,
      props = _ref3.props,
      value = _ref3.value;
    return ['p-rating-item', {
      'p-rating-item-active': value <= props.modelValue,
      'p-focus': value === instance.focusedOptionIndex && instance.isFocusVisibleItem
    }];
  },
  onIcon: 'p-rating-icon',
  offIcon: 'p-rating-icon'
};
var RatingStyle = BaseStyle__default["default"].extend({
  name: 'rating',
  css: css,
  classes: classes
});

module.exports = RatingStyle;
