this.primevue = this.primevue || {};
this.primevue.megamenu = this.primevue.megamenu || {};
this.primevue.megamenu.style = (function (BaseStyle) {
    'use strict';

    function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

    var BaseStyle__default = /*#__PURE__*/_interopDefaultLegacy(BaseStyle);

    var css = "\n@layer primevue {\n    .p-megamenu {\n        display: flex;\n        position: relative;\n    }\n\n    .p-megamenu-root-list {\n        margin: 0;\n        padding: 0;\n        list-style: none;\n    }\n\n    .p-megamenu .p-menuitem-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        text-decoration: none;\n        overflow: hidden;\n        position: relative;\n    }\n\n    .p-megamenu .p-menuitem-text {\n        line-height: 1;\n    }\n\n    .p-megamenu-panel {\n        display: none;\n        width: auto;\n        z-index: 1;\n        left: 0;\n        min-width: 100%;\n    }\n\n    .p-megamenu-panel:not(.p-megamenu-mobile) {\n        position: absolute;\n    }\n\n    .p-megamenu-root-list > .p-menuitem-active > .p-megamenu-panel {\n        display: block;\n    }\n\n    .p-megamenu-submenu {\n        margin: 0;\n        padding: 0;\n        list-style: none;\n    }\n\n    .p-megamenu-button {\n        display: none;\n        cursor: pointer;\n        align-items: center;\n        justify-content: center;\n        text-decoration: none;\n    }\n\n    /* Horizontal */\n    .p-megamenu-horizontal {\n        align-items: center;\n    }\n\n    .p-megamenu-horizontal .p-megamenu-root-list {\n        display: flex;\n        align-items: center;\n        flex-wrap: wrap;\n    }\n\n    .p-megamenu-horizontal .p-megamenu-end {\n        margin-left: auto;\n        align-self: center;\n    }\n\n    /* Vertical */\n    .p-megamenu-vertical {\n        flex-direction: column;\n    }\n    \n    .p-megamenu-vertical:not(.p-megamenu-mobile) {\n        display: inline-flex;\n    }\n\n    .p-megamenu-vertical .p-megamenu-root-list {\n        flex-direction: column;\n    }\n\n    .p-megamenu-vertical:not(.p-megamenu-mobile) .p-megamenu-root-list > .p-menuitem-active > .p-megamenu-panel {\n        left: 100%;\n        top: 0;\n    }\n\n    .p-megamenu-vertical .p-megamenu-root-list > .p-menuitem > .p-menuitem-content > .p-menuitem-link > .p-submenu-icon {\n        margin-left: auto;\n    }\n\n    .p-megamenu-grid {\n        display: flex;\n    }\n\n    .p-megamenu-col-2,\n    .p-megamenu-col-3,\n    .p-megamenu-col-4,\n    .p-megamenu-col-6,\n    .p-megamenu-col-12 {\n        flex: 0 0 auto;\n        padding: 0.5rem;\n    }\n\n    .p-megamenu-col-2 {\n        width: 16.6667%;\n    }\n\n    .p-megamenu-col-3 {\n        width: 25%;\n    }\n\n    .p-megamenu-col-4 {\n        width: 33.3333%;\n    }\n\n    .p-megamenu-col-6 {\n        width: 50%;\n    }\n\n    .p-megamenu-col-12 {\n        width: 100%;\n    }\n\n    .p-megamenu.p-megamenu-mobile .p-megamenu-button {\n        display: flex;\n    }\n\n    .p-megamenu.p-megamenu-mobile .p-megamenu-root-list {\n        position: absolute;\n        display: none;\n        width: 100%;\n    }\n\n    .p-megamenu.p-megamenu-mobile .p-submenu-list {\n        width: 100%;\n        position: static;\n        box-shadow: none;\n        border: 0 none;\n    }\n\n    .p-megamenu.p-megamenu-mobile .p-megamenu-root-list .p-menuitem {\n        width: 100%;\n        position: static;\n    }\n\n    .p-megamenu.p-megamenu-mobile-active .p-megamenu-root-list {\n        display: flex;\n        flex-direction: column;\n        top: 100%;\n        left: 0;\n        z-index: 1;\n    }\n\n    .p-megamenu.p-megamenu-mobile .p-megamenu-grid {\n        flex-wrap: wrap;\n        overflow: auto;\n        max-height: 90%;\n    }\n}\n";
    var inlineStyles = {
      submenu: function submenu(_ref) {
        var instance = _ref.instance,
          processedItem = _ref.processedItem;
        return {
          display: instance.isItemActive(processedItem) ? 'block' : 'none'
        };
      }
    };
    var classes = {
      root: function root(_ref2) {
        var instance = _ref2.instance;
        return ['p-megamenu p-component', {
          'p-megamenu-mobile': instance.queryMatches,
          'p-megamenu-mobile-active': instance.mobileActive,
          'p-megamenu-horizontal': instance.horizontal,
          'p-megamenu-vertical': instance.vertical
        }];
      },
      start: 'p-megamenu-start',
      menubutton: 'p-megamenu-button',
      menu: 'p-megamenu-root-list',
      submenuHeader: function submenuHeader(_ref3) {
        var instance = _ref3.instance,
          processedItem = _ref3.processedItem;
        return ['p-megamenu-submenu-header p-submenu-header', {
          'p-disabled': instance.isItemDisabled(processedItem)
        }];
      },
      menuitem: function menuitem(_ref4) {
        var instance = _ref4.instance,
          processedItem = _ref4.processedItem;
        return ['p-menuitem', {
          'p-menuitem-active p-highlight': instance.isItemActive(processedItem),
          'p-focus': instance.isItemFocused(processedItem),
          'p-disabled': instance.isItemDisabled(processedItem)
        }];
      },
      content: 'p-menuitem-content',
      action: 'p-menuitem-link',
      icon: 'p-menuitem-icon',
      label: 'p-menuitem-text',
      submenuIcon: 'p-submenu-icon',
      panel: 'p-megamenu-panel',
      grid: 'p-megamenu-grid',
      column: function column(_ref5) {
        var instance = _ref5.instance,
          processedItem = _ref5.processedItem;
        var length = instance.isItemGroup(processedItem) ? processedItem.items.length : 0;
        var columnClass;
        if (instance.$parentInstance.queryMatches) columnClass = 'p-megamenu-col-12';else {
          switch (length) {
            case 2:
              columnClass = 'p-megamenu-col-6';
              break;
            case 3:
              columnClass = 'p-megamenu-col-4';
              break;
            case 4:
              columnClass = 'p-megamenu-col-3';
              break;
            case 6:
              columnClass = 'p-megamenu-col-2';
              break;
            default:
              columnClass = 'p-megamenu-col-12';
              break;
          }
        }
        return columnClass;
      },
      submenu: 'p-submenu-list p-megamenu-submenu',
      submenuLabel: 'p-menuitem-text',
      separator: 'p-menuitem-separator',
      end: 'p-megamenu-end'
    };
    var MegaMenuStyle = BaseStyle__default["default"].extend({
      name: 'megamenu',
      css: css,
      classes: classes,
      inlineStyles: inlineStyles
    });

    return MegaMenuStyle;

})(primevue.base.style);
