import e from"primevue/button";import t from"primevue/icons/plus";import i from"primevue/icons/times";import l from"primevue/icons/upload";import n from"primevue/message";import o from"primevue/progressbar";import s from"primevue/ripple";import{DomHandler as a}from"primevue/utils";import r from"primevue/basecomponent";import u from"primevue/fileupload/style";import c from"primevue/badge";import{resolveComponent as p,openBlock as d,createElementBlock as f,Fragment as h,renderList as m,mergeProps as y,createElementVNode as v,toDisplayString as g,createVNode as b,normalizeClass as F,withCtx as B,createBlock as I,resolveDynamicComponent as C,resolveDirective as L,renderSlot as x,withDirectives as S,withKeys as $,createCommentVNode as w,createTextVNode as U}from"vue";var k={name:"BaseFileUpload",extends:r,props:{name:{type:String,default:null},url:{type:String,default:null},mode:{type:String,default:"advanced"},multiple:{type:Boolean,default:!1},accept:{type:String,default:null},disabled:{type:Boolean,default:!1},auto:{type:Boolean,default:!1},maxFileSize:{type:Number,default:null},invalidFileSizeMessage:{type:String,default:"{0}: Invalid file size, file size should be smaller than {1}."},invalidFileTypeMessage:{type:String,default:"{0}: Invalid file type, allowed file types: {1}."},fileLimit:{type:Number,default:null},invalidFileLimitMessage:{type:String,default:"Maximum number of files exceeded, limit is {0} at most."},withCredentials:{type:Boolean,default:!1},previewWidth:{type:Number,default:50},chooseLabel:{type:String,default:null},uploadLabel:{type:String,default:null},cancelLabel:{type:String,default:null},customUpload:{type:Boolean,default:!1},showUploadButton:{type:Boolean,default:!0},showCancelButton:{type:Boolean,default:!0},chooseIcon:{type:String,default:void 0},uploadIcon:{type:String,default:void 0},cancelIcon:{type:String,default:void 0},style:null,class:null},style:u,provide:function(){return{$parentInstance:this}}},E={name:"FileContent",hostName:"FileUpload",extends:r,emits:["remove"],props:{files:{type:Array,default:function(){return[]}},badgeSeverity:{type:String,default:"warning"},badgeValue:{type:String,default:null},previewWidth:{type:Number,default:50},templates:{type:null,default:null}},methods:{formatSize:function(e){var t,i=(null===(t=this.$primevue.config.locale)||void 0===t?void 0:t.fileSizeTypes)||["B","KB","MB","GB","TB","PB","EB","ZB","YB"];if(0===e)return"0 ".concat(i[0]);var l=Math.floor(Math.log(e)/Math.log(1024)),n=parseFloat((e/Math.pow(1024,l)).toFixed(3));return"".concat(n," ").concat(i[l])}},components:{FileUploadButton:e,FileUploadBadge:c,TimesIcon:i}},M=["alt","src","width"];function D(e){return A(e)||z(e)||W(e)||T()}function T(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function z(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function A(e){if(Array.isArray(e))return O(e)}function P(e,t){var i="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!i){if(Array.isArray(e)||(i=W(e))||t&&e&&"number"==typeof e.length){i&&(e=i);var l=0,n=function(){};return{s:n,n:function(){return l>=e.length?{done:!0}:{done:!1,value:e[l++]}},e:function(e){throw e},f:n}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,s=!0,a=!1;return{s:function(){i=i.call(e)},n:function(){var e=i.next();return s=e.done,e},e:function(e){a=!0,o=e},f:function(){try{s||null==i.return||i.return()}finally{if(a)throw o}}}}function W(e,t){if(e){if("string"==typeof e)return O(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);return"Object"===i&&e.constructor&&(i=e.constructor.name),"Map"===i||"Set"===i?Array.from(e):"Arguments"===i||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)?O(e,t):void 0}}function O(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,l=new Array(t);i<t;i++)l[i]=e[i];return l}E.render=function(e,t,i,l,n,o){var s=p("FileUploadBadge"),a=p("TimesIcon"),r=p("FileUploadButton");return d(!0),f(h,null,m(i.files,(function(t,l){return d(),f("div",y({key:t.name+t.type+t.size,class:e.cx("file")},e.ptm("file")),[v("img",y({role:"presentation",class:e.cx("thumbnail"),alt:t.name,src:t.objectURL,width:i.previewWidth},e.ptm("thumbnail")),null,16,M),v("div",y({class:e.cx("details")},e.ptm("details")),[v("div",y({class:e.cx("fileName")},e.ptm("fileName")),g(t.name),17),v("span",y({class:e.cx("fileSize")},e.ptm("fileSize")),g(o.formatSize(t.size)),17),b(s,{value:i.badgeValue,class:F(e.cx("badge")),severity:i.badgeSeverity,unstyled:e.unstyled,pt:e.ptm("badge")},null,8,["value","class","severity","unstyled","pt"])],16),v("div",y({class:e.cx("actions")},e.ptm("actions")),[b(r,{onClick:function(t){return e.$emit("remove",l)},text:"",rounded:"",severity:"danger",class:F(e.cx("removeButton")),unstyled:e.unstyled,pt:e.ptm("removeButton")},{icon:B((function(n){return[i.templates.fileremoveicon?(d(),I(C(i.templates.fileremoveicon),{key:0,class:F(n.class),file:t,index:l},null,8,["class","file","index"])):(d(),I(a,y({key:1,class:n.class,"aria-hidden":"true"},e.ptm("removeButton").icon),null,16,["class"]))]})),_:2},1032,["onClick","class","unstyled","pt"])],16)],16)})),128)};var R={name:"FileUpload",extends:k,emits:["select","uploader","before-upload","progress","upload","error","before-send","clear","remove","remove-uploaded-file"],duplicateIEEvent:!1,data:function(){return{uploadedFileCount:0,files:[],messages:[],focused:!1,progress:null,uploadedFiles:[]}},methods:{onFileSelect:function(e){if("drop"!==e.type&&this.isIE11()&&this.duplicateIEEvent)this.duplicateIEEvent=!1;else{this.messages=[],this.files=this.files||[];var t,i=P(e.dataTransfer?e.dataTransfer.files:e.target.files);try{for(i.s();!(t=i.n()).done;){var l=t.value;this.isFileSelected(l)||this.validate(l)&&(this.isImage(l)&&(l.objectURL=window.URL.createObjectURL(l)),this.files.push(l))}}catch(e){i.e(e)}finally{i.f()}this.$emit("select",{originalEvent:e,files:this.files}),this.fileLimit&&this.checkFileLimit(),this.auto&&this.hasFiles&&!this.isFileLimitExceeded()&&this.upload(),"drop"!==e.type&&this.isIE11()?this.clearIEInput():this.clearInputElement()}},choose:function(){this.$refs.fileInput.click()},upload:function(){var e=this;if(this.customUpload)this.fileLimit&&(this.uploadedFileCount+=this.files.length),this.$emit("uploader",{files:this.files}),this.clear();else{var t=new XMLHttpRequest,i=new FormData;this.$emit("before-upload",{xhr:t,formData:i});var l,n=P(this.files);try{for(n.s();!(l=n.n()).done;){var o=l.value;i.append(this.name,o,o.name)}}catch(e){n.e(e)}finally{n.f()}t.upload.addEventListener("progress",(function(t){t.lengthComputable&&(e.progress=Math.round(100*t.loaded/t.total)),e.$emit("progress",{originalEvent:t,progress:e.progress})})),t.onreadystatechange=function(){var i;4===t.readyState&&(e.progress=0,t.status>=200&&t.status<300?(e.fileLimit&&(e.uploadedFileCount+=e.files.length),e.$emit("upload",{xhr:t,files:e.files})):e.$emit("error",{xhr:t,files:e.files}),(i=e.uploadedFiles).push.apply(i,D(e.files)),e.clear())},t.open("POST",this.url,!0),this.$emit("before-send",{xhr:t,formData:i}),t.withCredentials=this.withCredentials,t.send(i)}},clear:function(){this.files=[],this.messages=null,this.$emit("clear"),this.isAdvanced&&this.clearInputElement()},onFocus:function(){this.focused=!0},onBlur:function(){this.focused=!1},isFileSelected:function(e){if(this.files&&this.files.length){var t,i=P(this.files);try{for(i.s();!(t=i.n()).done;){var l=t.value;if(l.name+l.type+l.size===e.name+e.type+e.size)return!0}}catch(e){i.e(e)}finally{i.f()}}return!1},isIE11:function(){return!!window.MSInputMethodContext&&!!document.documentMode},validate:function(e){return this.accept&&!this.isFileTypeValid(e)?(this.messages.push(this.invalidFileTypeMessage.replace("{0}",e.name).replace("{1}",this.accept)),!1):!(this.maxFileSize&&e.size>this.maxFileSize)||(this.messages.push(this.invalidFileSizeMessage.replace("{0}",e.name).replace("{1}",this.formatSize(this.maxFileSize))),!1)},isFileTypeValid:function(e){var t,i=this.accept.split(",").map((function(e){return e.trim()})),l=P(i);try{for(l.s();!(t=l.n()).done;){var n=t.value;if(this.isWildcard(n)?this.getTypeClass(e.type)===this.getTypeClass(n):e.type==n||this.getFileExtension(e).toLowerCase()===n.toLowerCase())return!0}}catch(e){l.e(e)}finally{l.f()}return!1},getTypeClass:function(e){return e.substring(0,e.indexOf("/"))},isWildcard:function(e){return-1!==e.indexOf("*")},getFileExtension:function(e){return"."+e.name.split(".").pop()},isImage:function(e){return/^image\//.test(e.type)},onDragEnter:function(e){this.disabled||(e.stopPropagation(),e.preventDefault())},onDragOver:function(e){this.disabled||(!this.isUnstyled&&a.addClass(this.$refs.content,"p-fileupload-highlight"),this.$refs.content.setAttribute("data-p-highlight",!0),e.stopPropagation(),e.preventDefault())},onDragLeave:function(){this.disabled||(!this.isUnstyled&&a.removeClass(this.$refs.content,"p-fileupload-highlight"),this.$refs.content.setAttribute("data-p-highlight",!1))},onDrop:function(e){if(!this.disabled){!this.isUnstyled&&a.removeClass(this.$refs.content,"p-fileupload-highlight"),this.$refs.content.setAttribute("data-p-highlight",!1),e.stopPropagation(),e.preventDefault();var t=e.dataTransfer?e.dataTransfer.files:e.target.files;(this.multiple||t&&1===t.length)&&this.onFileSelect(e)}},onBasicUploaderClick:function(e){this.hasFiles?this.upload():0===e.button&&this.$refs.fileInput.click()},remove:function(e){this.clearInputElement();var t=this.files.splice(e,1)[0];this.files=D(this.files),this.$emit("remove",{file:t,files:this.files})},removeUploadedFile:function(e){var t=this.uploadedFiles.splice(e,1)[0];this.uploadedFiles=D(this.uploadedFiles),this.$emit("remove-uploaded-file",{file:t,files:this.uploadedFiles})},clearInputElement:function(){this.$refs.fileInput.value=""},clearIEInput:function(){this.$refs.fileInput&&(this.duplicateIEEvent=!0,this.$refs.fileInput.value="")},formatSize:function(e){var t,i=(null===(t=this.$primevue.config.locale)||void 0===t?void 0:t.fileSizeTypes)||["B","KB","MB","GB","TB","PB","EB","ZB","YB"];if(0===e)return"0 ".concat(i[0]);var l=Math.floor(Math.log(e)/Math.log(1024)),n=parseFloat((e/Math.pow(1024,l)).toFixed(3));return"".concat(n," ").concat(i[l])},isFileLimitExceeded:function(){return this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount&&this.focused&&(this.focused=!1),this.fileLimit&&this.fileLimit<this.files.length+this.uploadedFileCount},checkFileLimit:function(){this.isFileLimitExceeded()&&this.messages.push(this.invalidFileLimitMessage.replace("{0}",this.fileLimit.toString()))},onMessageClose:function(){this.messages=null}},computed:{isAdvanced:function(){return"advanced"===this.mode},isBasic:function(){return"basic"===this.mode},chooseButtonClass:function(){return[this.cx("chooseButton"),this.class]},basicChooseButtonLabel:function(){return this.auto?this.chooseButtonLabel:this.hasFiles?this.files.map((function(e){return e.name})).join(", "):this.chooseButtonLabel},hasFiles:function(){return this.files&&this.files.length>0},hasUploadedFiles:function(){return this.uploadedFiles&&this.uploadedFiles.length>0},chooseDisabled:function(){return this.disabled||this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount},uploadDisabled:function(){return this.disabled||!this.hasFiles||this.fileLimit&&this.fileLimit<this.files.length},cancelDisabled:function(){return this.disabled||!this.hasFiles},chooseButtonLabel:function(){return this.chooseLabel||this.$primevue.config.locale.choose},uploadButtonLabel:function(){return this.uploadLabel||this.$primevue.config.locale.upload},cancelButtonLabel:function(){return this.cancelLabel||this.$primevue.config.locale.cancel},completedLabel:function(){return this.$primevue.config.locale.completed},pendingLabel:function(){return this.$primevue.config.locale.pending}},components:{FileUploadButton:e,FileUploadProgressBar:o,FileUploadMessage:n,FileContent:E,PlusIcon:t,UploadIcon:l,TimesIcon:i},directives:{ripple:s}},V=["multiple","accept","disabled"],j=["accept","disabled","multiple"];R.render=function(e,t,i,l,n,o){var s=p("FileUploadButton"),a=p("FileUploadProgressBar"),r=p("FileUploadMessage"),u=p("FileContent"),c=L("ripple");return o.isAdvanced?(d(),f("div",y({key:0,class:e.cx("root")},e.ptm("root"),{"data-pc-name":"fileupload"}),[v("input",y({ref:"fileInput",type:"file",onChange:t[0]||(t[0]=function(){return o.onFileSelect&&o.onFileSelect.apply(o,arguments)}),multiple:e.multiple,accept:e.accept,disabled:o.chooseDisabled},e.ptm("input")),null,16,V),v("div",y({class:e.cx("buttonbar")},e.ptm("buttonbar")),[x(e.$slots,"header",{files:n.files,uploadedFiles:n.uploadedFiles,chooseCallback:o.choose,uploadCallback:o.upload,clearCallback:o.clear},(function(){return[S((d(),f("span",y({class:o.chooseButtonClass,style:e.style,onClick:t[1]||(t[1]=function(){return o.choose&&o.choose.apply(o,arguments)}),onKeydown:t[2]||(t[2]=$((function(){return o.choose&&o.choose.apply(o,arguments)}),["enter"])),onFocus:t[3]||(t[3]=function(){return o.onFocus&&o.onFocus.apply(o,arguments)}),onBlur:t[4]||(t[4]=function(){return o.onBlur&&o.onBlur.apply(o,arguments)}),tabindex:"0"},e.ptm("chooseButton")),[x(e.$slots,"chooseicon",{class:F(e.cx("chooseIcon"))},(function(){return[(d(),I(C(e.chooseIcon?"span":"PlusIcon"),y({class:[e.cx("chooseIcon"),e.chooseIcon],"aria-hidden":"true"},e.ptm("chooseIcon")),null,16,["class"]))]})),v("span",y({class:e.cx("chooseButtonLabel")},e.ptm("chooseButtonLabel")),g(o.chooseButtonLabel),17)],16)),[[c]]),e.showUploadButton?(d(),I(s,{key:0,label:o.uploadButtonLabel,onClick:o.upload,disabled:o.uploadDisabled,unstyled:e.unstyled,pt:e.ptm("uploadButton"),"data-pc-section":"uploadbutton"},{icon:B((function(t){return[x(e.$slots,"uploadicon",{},(function(){return[(d(),I(C(e.uploadIcon?"span":"UploadIcon"),y({class:[t.class,e.uploadIcon],"aria-hidden":"true"},e.ptm("uploadButton").icon,{"data-pc-section":"uploadbuttonicon"}),null,16,["class"]))]}))]})),_:3},8,["label","onClick","disabled","unstyled","pt"])):w("",!0),e.showCancelButton?(d(),I(s,{key:1,label:o.cancelButtonLabel,onClick:o.clear,disabled:o.cancelDisabled,unstyled:e.unstyled,pt:e.ptm("cancelButton"),"data-pc-section":"cancelbutton"},{icon:B((function(t){return[x(e.$slots,"cancelicon",{},(function(){return[(d(),I(C(e.cancelIcon?"span":"TimesIcon"),y({class:[t.class,e.cancelIcon],"aria-hidden":"true"},e.ptm("cancelButton").icon,{"data-pc-section":"cancelbuttonicon"}),null,16,["class"]))]}))]})),_:3},8,["label","onClick","disabled","unstyled","pt"])):w("",!0)]}))],16),v("div",y({ref:"content",class:e.cx("content"),onDragenter:t[5]||(t[5]=function(){return o.onDragEnter&&o.onDragEnter.apply(o,arguments)}),onDragover:t[6]||(t[6]=function(){return o.onDragOver&&o.onDragOver.apply(o,arguments)}),onDragleave:t[7]||(t[7]=function(){return o.onDragLeave&&o.onDragLeave.apply(o,arguments)}),onDrop:t[8]||(t[8]=function(){return o.onDrop&&o.onDrop.apply(o,arguments)})},e.ptm("content"),{"data-p-highlight":!1}),[x(e.$slots,"content",{files:n.files,uploadedFiles:n.uploadedFiles,removeUploadedFileCallback:o.removeUploadedFile,removeFileCallback:o.remove,progress:n.progress,messages:n.messages},(function(){return[o.hasFiles?(d(),I(a,{key:0,value:n.progress,showValue:!1,unstyled:e.unstyled,pt:e.ptm("progressbar")},null,8,["value","unstyled","pt"])):w("",!0),(d(!0),f(h,null,m(n.messages,(function(t){return d(),I(r,{key:t,severity:"error",onClose:o.onMessageClose,unstyled:e.unstyled,pt:e.ptm("message")},{default:B((function(){return[U(g(t),1)]})),_:2},1032,["onClose","unstyled","pt"])})),128)),o.hasFiles?(d(),I(u,{key:1,files:n.files,onRemove:o.remove,badgeValue:o.pendingLabel,previewWidth:e.previewWidth,templates:e.$slots,unstyled:e.unstyled,pt:e.pt},null,8,["files","onRemove","badgeValue","previewWidth","templates","unstyled","pt"])):w("",!0),b(u,{files:n.uploadedFiles,onRemove:o.removeUploadedFile,badgeValue:o.completedLabel,badgeSeverity:"success",previewWidth:e.previewWidth,templates:e.$slots,unstyled:e.unstyled,pt:e.pt},null,8,["files","onRemove","badgeValue","previewWidth","templates","unstyled","pt"])]})),!e.$slots.empty||o.hasFiles||o.hasUploadedFiles?w("",!0):(d(),f("div",y({key:0,class:e.cx("empty")},e.ptm("empty")),[x(e.$slots,"empty")],16))],16)],16)):o.isBasic?(d(),f("div",y({key:1,class:e.cx("root")},e.ptm("root"),{"data-pc-name":"fileupload"}),[(d(!0),f(h,null,m(n.messages,(function(t){return d(),I(r,{key:t,severity:"error",onClose:o.onMessageClose,unstyled:e.unstyled,pt:e.ptm("messages")},{default:B((function(){return[U(g(t),1)]})),_:2},1032,["onClose","unstyled","pt"])})),128)),S((d(),f("span",y({class:o.chooseButtonClass,style:e.style,onMouseup:t[12]||(t[12]=function(){return o.onBasicUploaderClick&&o.onBasicUploaderClick.apply(o,arguments)}),onKeydown:t[13]||(t[13]=$((function(){return o.choose&&o.choose.apply(o,arguments)}),["enter"])),onFocus:t[14]||(t[14]=function(){return o.onFocus&&o.onFocus.apply(o,arguments)}),onBlur:t[15]||(t[15]=function(){return o.onBlur&&o.onBlur.apply(o,arguments)}),tabindex:"0"},e.ptm("chooseButton")),[!o.hasFiles||e.auto?x(e.$slots,"uploadicon",{key:0,class:F(e.cx("uploadIcon"))},(function(){return[(d(),I(C(e.uploadIcon?"span":"UploadIcon"),y({class:[e.cx("uploadIcon"),e.uploadIcon],"aria-hidden":"true"},e.ptm("uploadIcon")),null,16,["class"]))]})):x(e.$slots,"chooseicon",{key:1,class:F(e.cx("chooseIcon"))},(function(){return[(d(),I(C(e.chooseIcon?"span":"PlusIcon"),y({class:[e.cx("chooseIcon"),e.chooseIcon],"aria-hidden":"true"},e.ptm("chooseIcon")),null,16,["class"]))]})),v("span",y({class:e.cx("label")},e.ptm("label")),g(o.basicChooseButtonLabel),17),o.hasFiles?w("",!0):(d(),f("input",y({key:2,ref:"fileInput",type:"file",accept:e.accept,disabled:e.disabled,multiple:e.multiple,onChange:t[9]||(t[9]=function(){return o.onFileSelect&&o.onFileSelect.apply(o,arguments)}),onFocus:t[10]||(t[10]=function(){return o.onFocus&&o.onFocus.apply(o,arguments)}),onBlur:t[11]||(t[11]=function(){return o.onBlur&&o.onBlur.apply(o,arguments)})},e.ptm("input")),null,16,j))],16)),[[c]])],16)):w("",!0)};export{R as default};
