this.primevue = this.primevue || {};
this.primevue.contextmenu = this.primevue.contextmenu || {};
this.primevue.contextmenu.style = (function (BaseStyle) {
    'use strict';

    function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

    var BaseStyle__default = /*#__PURE__*/_interopDefaultLegacy(BaseStyle);

    var css = "\n@layer primevue {\n    .p-contextmenu ul {\n        margin: 0;\n        padding: 0;\n        list-style: none;\n    }\n\n    .p-contextmenu .p-submenu-list {\n        position: absolute;\n        min-width: 100%;\n        z-index: 1;\n    }\n\n    .p-contextmenu .p-menuitem-link {\n        cursor: pointer;\n        display: flex;\n        align-items: center;\n        text-decoration: none;\n        overflow: hidden;\n        position: relative;\n    }\n\n    .p-contextmenu .p-menuitem-text {\n        line-height: 1;\n    }\n\n    .p-contextmenu .p-menuitem {\n        position: relative;\n    }\n\n    .p-contextmenu .p-menuitem-link .p-submenu-icon {\n        margin-left: auto;\n    }\n\n    .p-contextmenu-enter-from,\n    .p-contextmenu-leave-active {\n        opacity: 0;\n    }\n\n    .p-contextmenu-enter-active {\n        transition: opacity 250ms;\n    }\n}\n";
    var classes = {
      root: function root(_ref) {
        var instance = _ref.instance;
        return ['p-contextmenu p-component', {
          'p-input-filled': instance.$primevue.config.inputStyle === 'filled',
          'p-ripple-disabled': instance.$primevue.config.ripple === false
        }];
      },
      menu: 'p-contextmenu-root-list',
      menuitem: function menuitem(_ref2) {
        var instance = _ref2.instance,
          processedItem = _ref2.processedItem;
        return ['p-menuitem', {
          'p-menuitem-active p-highlight': instance.isItemActive(processedItem),
          'p-focus': instance.isItemFocused(processedItem),
          'p-disabled': instance.isItemDisabled(processedItem)
        }];
      },
      content: 'p-menuitem-content',
      action: 'p-menuitem-link',
      icon: 'p-menuitem-icon',
      label: 'p-menuitem-text',
      submenuIcon: 'p-submenu-icon',
      submenu: 'p-submenu-list',
      separator: 'p-menuitem-separator'
    };
    var ContextMenuStyle = BaseStyle__default["default"].extend({
      name: 'contextmenu',
      css: css,
      classes: classes
    });

    return ContextMenuStyle;

})(primevue.base.style);
