import BaseStyle from 'primevue/base/style';

var css = "\n@layer primevue {\n    .p-colorpicker-panel .p-colorpicker-color {\n        background: linear-gradient(to top, #000 0%, rgb(0 0 0 / 0) 100%), linear-gradient(to right, #fff 0%, rgb(255 255 255 / 0) 100%)\n    }\n\n    .p-colorpicker-panel .p-colorpicker-hue {\n        background: linear-gradient(0deg, red 0, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, red)\n    }\n}\n";
var classes = {
  root: function root(_ref) {
    var props = _ref.props;
    return ['p-colorpicker p-component', {
      'p-colorpicker-overlay': !props.inline
    }];
  },
  input: function input(_ref2) {
    var props = _ref2.props;
    return ['p-colorpicker-preview p-inputtext', {
      'p-disabled': props.disabled
    }];
  },
  panel: function panel(_ref3) {
    var instance = _ref3.instance,
      props = _ref3.props;
    return ['p-colorpicker-panel', {
      'p-colorpicker-overlay-panel': !props.inline,
      'p-disabled': props.disabled,
      'p-input-filled': instance.$primevue.config.inputStyle === 'filled',
      'p-ripple-disabled': instance.$primevue.config.ripple === false
    }];
  },
  content: 'p-colorpicker-content',
  selector: 'p-colorpicker-color-selector',
  color: 'p-colorpicker-color',
  colorHandle: 'p-colorpicker-color-handle',
  hue: 'p-colorpicker-hue',
  hueHandle: 'p-colorpicker-hue-handle'
};
var ColorPickerStyle = BaseStyle.extend({
  name: 'colorpicker',
  css: css,
  classes: classes
});

export { ColorPickerStyle as default };
