import BaseStyle from 'primevue/base/style';

var css = "\n@layer primevue {\n    .p-breadcrumb {\n        overflow-x: auto;\n    }\n\n    .p-breadcrumb .p-breadcrumb-list {\n        margin: 0;\n        padding: 0;\n        list-style-type: none;\n        display: flex;\n        align-items: center;\n        flex-wrap: nowrap;\n    }\n\n    .p-breadcrumb .p-menuitem-text {\n        line-height: 1;\n    }\n\n    .p-breadcrumb .p-menuitem-link {\n        text-decoration: none;\n        display: flex;\n        align-items: center;\n    }\n\n    .p-breadcrumb .p-menuitem-separator {\n        display: flex;\n        align-items: center;\n    }\n\n    .p-breadcrumb::-webkit-scrollbar {\n        display: none;\n    }\n}\n";
var classes = {
  root: 'p-breadcrumb p-component',
  menu: 'p-breadcrumb-list',
  home: 'p-breadcrumb-home',
  separator: 'p-menuitem-separator',
  menuitem: function menuitem(_ref) {
    var instance = _ref.instance;
    return ['p-menuitem', {
      'p-disabled': instance.disabled()
    }];
  },
  action: 'p-menuitem-link',
  icon: 'p-menuitem-icon',
  label: 'p-menuitem-text'
};
var BreadcrumbStyle = BaseStyle.extend({
  name: 'breadcrumb',
  css: css,
  classes: classes
});

export { BreadcrumbStyle as default };
