import HTMLElementNamedNodeMap from '../html-element/HTMLElementNamedNodeMap.js';
import HTMLLinkElementUtility from './HTMLLinkElementUtility.js';
/**
 * Named Node Map.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/NamedNodeMap
 */
export default class HTMLLinkElementNamedNodeMap extends HTMLElementNamedNodeMap {
    /**
     * @override
     */
    setNamedItem(item) {
        const replacedItem = super.setNamedItem(item);
        if (item.name === 'rel' && this._ownerElement._relList) {
            this._ownerElement._relList._updateIndices();
        }
        if (item.name === 'rel' || item.name === 'href') {
            HTMLLinkElementUtility.loadExternalStylesheet(this._ownerElement);
        }
        return replacedItem || null;
    }
    /**
     * @override
     */
    removeNamedItem(name) {
        const removedItem = super.removeNamedItem(name);
        if (removedItem && removedItem.name === 'rel' && this._ownerElement._relList) {
            this._ownerElement._relList._updateIndices();
        }
        return removedItem;
    }
}
//# sourceMappingURL=HTMLLinkElementNamedNodeMap.js.map