import FocusEvent from '../../event/events/FocusEvent.js';
/**
 * HTMLElement utility.
 */
export default class HTMLElementUtility {
    /**
     * Triggers a blur event.
     *
     * @param element Element.
     */
    static blur(element) {
        if (element.ownerDocument['_activeElement'] !== element || !element.isConnected) {
            return;
        }
        element.ownerDocument['_activeElement'] = null;
        element.dispatchEvent(new FocusEvent('blur', {
            bubbles: false,
            composed: true
        }));
        element.dispatchEvent(new FocusEvent('focusout', {
            bubbles: true,
            composed: true
        }));
    }
    /**
     * Triggers a focus event.
     *
     * @param element Element.
     */
    static focus(element) {
        if (element.ownerDocument['_activeElement'] === element || !element.isConnected) {
            return;
        }
        if (element.ownerDocument['_activeElement'] !== null) {
            element.ownerDocument['_activeElement'].blur();
        }
        element.ownerDocument['_activeElement'] = element;
        element.dispatchEvent(new FocusEvent('focus', {
            bubbles: false,
            composed: true
        }));
        element.dispatchEvent(new FocusEvent('focusin', {
            bubbles: true,
            composed: true
        }));
    }
}
//# sourceMappingURL=HTMLElementUtility.js.map