import EventTarget from '../event/EventTarget.js';
import Event from '../event/Event.js';
/**
 * AbortSignal.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal
 */
export default class AbortSignal extends EventTarget {
    constructor() {
        super(...arguments);
        this.aborted = false;
        this.reason = null;
        this.onabort = null;
    }
    /**
     * Aborts the signal.
     *
     * @param [reason] Reason.
     */
    _abort(reason) {
        if (this.aborted) {
            return;
        }
        if (reason) {
            this.reason = reason;
        }
        this.aborted = true;
        this.dispatchEvent(new Event('abort'));
    }
    /**
     * Returns an AbortSignal instance that has been set as aborted.
     *
     * @param [reason] Reason.
     * @returns AbortSignal instance.
     */
    static abort(reason) {
        const signal = new AbortSignal();
        if (reason) {
            signal.reason = reason;
        }
        signal.aborted = true;
        return signal;
    }
}
//# sourceMappingURL=AbortSignal.js.map