import Event from '../Event.js';
/**
 * Message event.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/MessageEvent
 */
export default class MessageEvent extends Event {
    /**
     * Constructor.
     *
     * @param type Event type.
     * @param [eventInit] Event init.
     */
    constructor(type, eventInit) {
        super(type, eventInit);
        this.data = null;
        this.origin = '';
        this.lastEventId = '';
        this.source = null;
        this.ports = [];
        this.data = eventInit?.data !== undefined ? eventInit.data : null;
        this.origin = eventInit?.origin || '';
        this.lastEventId = eventInit?.lastEventId || '';
        this.source = eventInit?.source || null;
        this.ports = eventInit?.ports || [];
    }
}
//# sourceMappingURL=MessageEvent.js.map