import NodeTypeEnum from '../nodes/node/NodeTypeEnum.js';
import { performance } from 'perf_hooks';
import EventPhaseEnum from './EventPhaseEnum.js';
/**
 * Event.
 */
export default class Event {
    /**
     * Constructor.
     *
     * @param type Event type.
     * @param [eventInit] Event init.
     */
    constructor(type, eventInit = null) {
        this.composed = false;
        this.bubbles = false;
        this.cancelable = false;
        this.defaultPrevented = false;
        this.eventPhase = EventPhaseEnum.none;
        this._immediatePropagationStopped = false;
        this._propagationStopped = false;
        this._target = null;
        this._currentTarget = null;
        this.timeStamp = performance.now();
        this.type = null;
        this._isInPassiveEventListener = false;
        this.NONE = EventPhaseEnum.none;
        this.CAPTURING_PHASE = EventPhaseEnum.capturing;
        this.AT_TARGET = EventPhaseEnum.atTarget;
        this.BUBBLING_PHASE = EventPhaseEnum.bubbling;
        this.type = type;
        if (eventInit) {
            this.bubbles = eventInit.bubbles || false;
            this.cancelable = eventInit.cancelable || false;
            this.composed = eventInit.composed || false;
        }
    }
    /**
     * Returns target.
     *
     * @returns Target.
     */
    get target() {
        return this._target;
    }
    /**
     * Returns target.
     *
     * @returns Target.
     */
    get currentTarget() {
        return this._currentTarget;
    }
    /**
     * Returns "true" if propagation has been stopped.
     *
     * @returns "true" if propagation has been stopped.
     */
    get cancelBubble() {
        return this._propagationStopped;
    }
    /**
     * Returns composed path.
     *
     * @returns Composed path.
     */
    composedPath() {
        if (!this._target) {
            return [];
        }
        const composedPath = [];
        let eventTarget = this._target;
        while (eventTarget) {
            composedPath.push(eventTarget);
            if (eventTarget.parentNode) {
                eventTarget = eventTarget.parentNode;
            }
            else if (this.composed &&
                eventTarget.nodeType === NodeTypeEnum.documentFragmentNode &&
                eventTarget.host) {
                eventTarget = eventTarget.host;
            }
            else if (eventTarget.nodeType === NodeTypeEnum.documentNode) {
                eventTarget = eventTarget.defaultView;
            }
            else {
                break;
            }
        }
        return composedPath;
    }
    /**
     * Init event.
     *
     * @deprecated
     * @param type Type.
     * @param [bubbles=false] "true" if it bubbles.
     * @param [cancelable=false] "true" if it cancelable.
     */
    initEvent(type, bubbles = false, cancelable = false) {
        this.type = type;
        this.bubbles = bubbles;
        this.cancelable = cancelable;
    }
    /**
     * Prevents default.
     */
    preventDefault() {
        if (!this._isInPassiveEventListener) {
            this.defaultPrevented = true;
        }
    }
    /**
     * Stops immediate propagation.
     */
    stopImmediatePropagation() {
        this._immediatePropagationStopped = true;
    }
    /**
     * Stops propagation.
     */
    stopPropagation() {
        this._propagationStopped = true;
    }
}
//# sourceMappingURL=Event.js.map