/// <reference types="node" resolution-mode="require"/>
/**
 * Handles async tasks.
 */
export default class AsyncTaskManager {
    private static taskID;
    private runningTasks;
    private runningTimers;
    private callbacks;
    /**
     * Returns a promise that is fulfilled when async tasks are complete.
     * This method is not part of the HTML standard.
     *
     * @returns Promise.
     */
    whenComplete(): Promise<void>;
    /**
     * Ends all tasks.
     *
     * @param [error] Error.
     */
    cancelAll(): void;
    /**
     * Starts a timer.
     *
     * @param timerID Timer ID.
     */
    startTimer(timerID: NodeJS.Timeout): void;
    /**
     * Ends a timer.
     *
     * @param timerID Timer ID.
     */
    endTimer(timerID: NodeJS.Timeout): void;
    /**
     * Starts an async task.
     *
     * @param abortHandler Abort handler.
     * @returns Task ID.
     */
    startTask(abortHandler?: () => void): number;
    /**
     * Ends an async task.
     *
     * @param taskID Task ID.
     */
    endTask(taskID: number): void;
    /**
     * Returns the amount of running tasks.
     *
     * @returns Count.
     */
    getTaskCount(): number;
    /**
     * Returns a new task ID.
     *
     * @returns Task ID.
     */
    private newTaskID;
    /**
     * Ends all tasks.
     *
     * @param [canceled] Canceled.
     */
    private endAll;
}
//# sourceMappingURL=AsyncTaskManager.d.ts.map