"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const HTMLElement_js_1 = __importDefault(require("../html-element/HTMLElement.cjs"));
const XMLSerializer_js_1 = __importDefault(require("../../xml-serializer/XMLSerializer.cjs"));
const XMLParser_js_1 = __importDefault(require("../../xml-parser/XMLParser.cjs"));
/**
 * HTML Template Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLTemplateElement.
 */
class HTMLTemplateElement extends HTMLElement_js_1.default {
    constructor() {
        super(...arguments);
        this.content = this.ownerDocument.createDocumentFragment();
    }
    /**
     * @override
     */
    get innerHTML() {
        return this.getInnerHTML();
    }
    /**
     * @override
     */
    set innerHTML(html) {
        for (const child of this.content._childNodes.slice()) {
            this.content.removeChild(child);
        }
        XMLParser_js_1.default.parse(this.ownerDocument, html, { rootNode: this.content });
    }
    /**
     * @override
     */
    get firstChild() {
        return this.content.firstChild;
    }
    /**
     * @override
     */
    get lastChild() {
        return this.content.lastChild;
    }
    /**
     * @override
     */
    getInnerHTML(options) {
        const xmlSerializer = new XMLSerializer_js_1.default({
            includeShadowRoots: options && options.includeShadowRoots,
            escapeEntities: false
        });
        let xml = '';
        for (const node of this.content._childNodes) {
            xml += xmlSerializer.serializeToString(node);
        }
        return xml;
    }
    /**
     * @override
     */
    appendChild(node) {
        return this.content.appendChild(node);
    }
    /**
     * @override
     */
    removeChild(node) {
        return this.content.removeChild(node);
    }
    /**
     * @override
     */
    insertBefore(newNode, referenceNode) {
        return this.content.insertBefore(newNode, referenceNode);
    }
    /**
     * @override
     */
    replaceChild(newChild, oldChild) {
        return this.content.replaceChild(newChild, oldChild);
    }
    /**
     * @override
     */
    cloneNode(deep = false) {
        const clone = super.cloneNode(deep);
        clone.content = this.content.cloneNode(deep);
        return clone;
    }
}
exports.default = HTMLTemplateElement;
//# sourceMappingURL=HTMLTemplateElement.cjs.map