"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Event_js_1 = __importDefault(require("../../event/Event.cjs"));
const DOMException_js_1 = __importDefault(require("../../exception/DOMException.cjs"));
const DOMExceptionNameEnum_js_1 = __importDefault(require("../../exception/DOMExceptionNameEnum.cjs"));
const ResourceFetch_js_1 = __importDefault(require("../../fetch/ResourceFetch.cjs"));
const WindowErrorUtility_js_1 = __importDefault(require("../../window/WindowErrorUtility.cjs"));
/**
 * Helper class for getting the URL relative to a Location object.
 */
class HTMLScriptElementUtility {
    /**
     * Returns a URL relative to the given Location object.
     *
     * @param options Options.
     * @param options.element Element.
     * @param element
     */
    static async loadExternalScript(element) {
        const src = element.getAttribute('src');
        const async = element.getAttribute('async') !== null;
        if (element.ownerDocument.defaultView.happyDOM.settings.disableJavaScriptFileLoading ||
            element.ownerDocument.defaultView.happyDOM.settings.disableJavaScriptEvaluation) {
            WindowErrorUtility_js_1.default.dispatchError(element, new DOMException_js_1.default(`Failed to load external script "${src}". JavaScript file loading is disabled.`, DOMExceptionNameEnum_js_1.default.notSupportedError));
            return;
        }
        if (async) {
            element.ownerDocument._readyStateManager.startTask();
            const code = await WindowErrorUtility_js_1.default.captureErrorAsync(element, async () => await ResourceFetch_js_1.default.fetch(element.ownerDocument, src));
            if (code) {
                WindowErrorUtility_js_1.default.captureErrorSync(element.ownerDocument.defaultView, () => element.ownerDocument.defaultView.eval(code));
                element.dispatchEvent(new Event_js_1.default('load'));
            }
            element.ownerDocument._readyStateManager.endTask();
        }
        else {
            const code = WindowErrorUtility_js_1.default.captureErrorSync(element, () => ResourceFetch_js_1.default.fetchSync(element.ownerDocument, src));
            if (code) {
                WindowErrorUtility_js_1.default.captureErrorSync(element.ownerDocument.defaultView, () => element.ownerDocument.defaultView.eval(code));
                element.dispatchEvent(new Event_js_1.default('load'));
            }
        }
    }
}
exports.default = HTMLScriptElementUtility;
//# sourceMappingURL=HTMLScriptElementUtility.cjs.map