import HTMLElement from '../html-element/HTMLElement.cjs';
import Event from '../../event/Event.cjs';
import HTMLInputElementSelectionModeEnum from './HTMLInputElementSelectionModeEnum.cjs';
import IHTMLInputElement from './IHTMLInputElement.cjs';
import IHTMLFormElement from '../html-form-element/IHTMLFormElement.cjs';
import File from '../../file/File.cjs';
import IFileList from './IFileList.cjs';
import INode from '../node/INode.cjs';
import INodeList from '../node/INodeList.cjs';
import IHTMLLabelElement from '../html-label-element/IHTMLLabelElement.cjs';
import INamedNodeMap from '../../named-node-map/INamedNodeMap.cjs';
/**
 * HTML Input Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement.
 *
 * Used as reference for some of the logic (like selection range):
 * https://github.com/jsdom/jsdom/blob/master/lib/jsdom/living/nodes/nodes/HTMLInputElement-impl.js (MIT licensed).
 */
export default class HTMLInputElement extends HTMLElement implements IHTMLInputElement {
    readonly attributes: INamedNodeMap;
    formAction: string;
    formMethod: string;
    _value: any;
    _height: number;
    _width: number;
    defaultChecked: boolean;
    _checked: boolean | null;
    files: IFileList<File>;
    readonly validationMessage = "";
    readonly validity: any;
    oninput: (event: Event) => void | null;
    oninvalid: (event: Event) => void | null;
    onselectionchange: (event: Event) => void | null;
    private _selectionStart;
    private _selectionEnd;
    private _selectionDirection;
    /**
     * Returns height.
     *
     * @returns Height.
     */
    get height(): number;
    /**
     * Sets height.
     *
     * @param height Height.
     */
    set height(height: number);
    /**
     * Returns width.
     *
     * @returns Width.
     */
    get width(): number;
    /**
     * Sets width.
     *
     * @param width Width.
     */
    set width(width: number);
    /**
     * Returns size.
     *
     * @returns Size.
     */
    get size(): number;
    /**
     * Sets size.
     *
     * @param size Size.
     */
    set size(size: number);
    /**
     * Returns minlength.
     *
     * @returns Min length.
     */
    get minLength(): number;
    /**
     * Sets minlength.
     *
     * @param minLength Min length.
     */
    set minLength(minlength: number);
    /**
     * Returns maxlength.
     *
     * @returns Max length.
     */
    get maxLength(): number;
    /**
     * Sets maxlength.
     *
     * @param maxlength Max length.
     */
    set maxLength(maxLength: number);
    /**
     * Returns type.
     *
     * @returns Type. Defaults to "text".
     */
    get type(): string;
    /**
     * Sets type.
     *
     * @param type Type.
     */
    set type(type: string);
    /**
     * Returns name.
     *
     * @returns Name.
     */
    get name(): string;
    /**
     * Sets name.
     *
     * @param name Name.
     */
    set name(name: string);
    /**
     * Returns alt.
     *
     * @returns Alt.
     */
    get alt(): string;
    /**
     * Sets alt.
     *
     * @param alt Alt.
     */
    set alt(alt: string);
    /**
     * Returns min.
     *
     * @returns Min.
     */
    get min(): string;
    /**
     * Sets min.
     *
     * @param min Min.
     */
    set min(min: string);
    /**
     * Returns max.
     *
     * @returns Max.
     */
    get max(): string;
    /**
     * Sets max.
     *
     * @param max Max.
     */
    set max(max: string);
    /**
     * Returns pattern.
     *
     * @returns Pattern.
     */
    get pattern(): string;
    /**
     * Sets pattern.
     *
     * @param pattern Pattern.
     */
    set pattern(pattern: string);
    /**
     * Returns placeholder.
     *
     * @returns Placeholder.
     */
    get placeholder(): string;
    /**
     * Sets placeholder.
     *
     * @param placeholder Placeholder.
     */
    set placeholder(placeholder: string);
    /**
     * Returns step.
     *
     * @returns Step.
     */
    get step(): string;
    /**
     * Sets step.
     *
     * @param step Step.
     */
    set step(step: string);
    /**
     * Returns inputmode.
     *
     * @returns Inputmode.
     */
    get inputmode(): string;
    /**
     * Sets inputmode.
     *
     * @param inputmode Inputmode.
     */
    set inputmode(inputmode: string);
    /**
     * Returns accept.
     *
     * @returns Accept.
     */
    get accept(): string;
    /**
     * Sets accept.
     *
     * @param accept Accept.
     */
    set accept(accept: string);
    /**
     * Returns allowdirs.
     *
     * @returns Allowdirs.
     */
    get allowdirs(): string;
    /**
     * Sets allowdirs.
     *
     * @param allowdirs Allowdirs.
     */
    set allowdirs(allowdirs: string);
    /**
     * Returns autocomplete.
     *
     * @returns Autocomplete.
     */
    get autocomplete(): string;
    /**
     * Sets autocomplete.
     *
     * @param autocomplete Autocomplete.
     */
    set autocomplete(autocomplete: string);
    /**
     * Returns src.
     *
     * @returns Src.
     */
    get src(): string;
    /**
     * Sets src.
     *
     * @param src Src.
     */
    set src(src: string);
    /**
     * Returns defaultValue.
     *
     * @returns Defaultvalue.
     */
    get defaultValue(): string;
    /**
     * Sets defaultValue.
     *
     * @param defaultValue Defaultvalue.
     */
    set defaultValue(defaultValue: string);
    /**
     * Returns read only.
     *
     * @returns Read only.
     */
    get readOnly(): boolean;
    /**
     * Sets read only.
     *
     * @param readOnly Read only.
     */
    set readOnly(readOnly: boolean);
    /**
     * Returns disabled.
     *
     * @returns Disabled.
     */
    get disabled(): boolean;
    /**
     * Sets disabled.
     *
     * @param disabled Disabled.
     */
    set disabled(disabled: boolean);
    /**
     * Returns autofocus.
     *
     * @returns Autofocus.
     */
    get autofocus(): boolean;
    /**
     * Sets autofocus.
     *
     * @param autofocus Autofocus.
     */
    set autofocus(autofocus: boolean);
    /**
     * Returns required.
     *
     * @returns Required.
     */
    get required(): boolean;
    /**
     * Sets required.
     *
     * @param required Required.
     */
    set required(required: boolean);
    /**
     * Returns indeterminate.
     *
     * @returns Indeterminate.
     */
    get indeterminate(): boolean;
    /**
     * Sets indeterminate.
     *
     * @param indeterminate Indeterminate.
     */
    set indeterminate(indeterminate: boolean);
    /**
     * Returns multiple.
     *
     * @returns Multiple.
     */
    get multiple(): boolean;
    /**
     * Sets multiple.
     *
     * @param multiple Multiple.
     */
    set multiple(multiple: boolean);
    /**
     * Returns checked.
     *
     * @returns Checked.
     */
    get checked(): boolean;
    /**
     * Sets checked.
     *
     * @param checked Checked.
     */
    set checked(checked: boolean);
    /**
     * Returns value.
     *
     * @returns Value.
     */
    get value(): string;
    /**
     * Sets value.
     *
     * @param value Value.
     */
    set value(value: string);
    /**
     * Returns selection start.
     *
     * @returns Selection start.
     */
    get selectionStart(): number;
    /**
     * Sets selection start.
     *
     * @param start Start.
     */
    set selectionStart(start: number);
    /**
     * Returns selection end.
     *
     * @returns Selection end.
     */
    get selectionEnd(): number;
    /**
     * Sets selection end.
     *
     * @param end End.
     */
    set selectionEnd(end: number);
    /**
     * Returns selection direction.
     *
     * @returns Selection direction.
     */
    get selectionDirection(): string;
    /**
     * Sets selection direction.
     *
     * @param direction Direction.
     */
    set selectionDirection(direction: string);
    /**
     * Returns no validate.
     *
     * @returns No validate.
     */
    get formNoValidate(): boolean;
    /**
     * Sets no validate.
     *
     * @param formNoValidate No validate.
     */
    set formNoValidate(formNoValidate: boolean);
    /**
     * Returns the parent form element.
     *
     * @returns Form.
     */
    get form(): IHTMLFormElement;
    /**
     * Returns "true" if it will validate.
     *
     * @returns "true" if it will validate.
     */
    get willValidate(): boolean;
    /**
     * Returns value as Date.
     *
     * @returns Date.
     */
    get valueAsDate(): Date;
    /**
     * Sets value from a Date.
     *
     * @param value Date.
     */
    set valueAsDate(value: Date | null);
    /**
     * Returns value as number.
     *
     * @returns Number.
     */
    get valueAsNumber(): number;
    /**
     * Sets value from a number.
     *
     * @param value number.
     */
    set valueAsNumber(value: number);
    /**
     * Returns the associated label elements.
     *
     * @returns Label elements.
     */
    get labels(): INodeList<IHTMLLabelElement>;
    /**
     * Sets validation message.
     *
     * @param message Message.
     */
    setCustomValidity(message: string): void;
    /**
     * Selects the text.
     */
    select(): void;
    /**
     * Set selection range.
     *
     * @param start Start.
     * @param end End.
     * @param [direction="none"] Direction.
     */
    setSelectionRange(start: number, end: number, direction?: string): void;
    /**
     * Set range text.
     *
     * @param replacement Replacement.
     * @param [start] Start.
     * @param [end] End.
     * @param [direction] Direction.
     * @param selectionMode
     */
    setRangeText(replacement: string, start?: number, end?: number, selectionMode?: HTMLInputElementSelectionModeEnum): void;
    /**
     * Checks validity.
     *
     * @returns "true" if the field is valid.
     */
    checkValidity(): boolean;
    /**
     * Reports validity.
     *
     * @returns "true" if the field is valid.
     */
    reportValidity(): boolean;
    /**
     * Steps up.
     *
     * @param [increment] Increment.
     */
    stepUp(increment?: number): void;
    /**
     * Steps down.
     *
     * @param [increment] Increment.
     */
    stepDown(increment?: number): void;
    /**
     * Clones a node.
     *
     * @override
     * @param [deep=false] "true" to clone deep.
     * @returns Cloned node.
     */
    cloneNode(deep?: boolean): IHTMLInputElement;
    /**
     * @override
     */
    dispatchEvent(event: Event): boolean;
    /**
     * @override
     */
    _connectToNode(parentNode?: INode): void;
    /**
     * Checks is selection is supported.
     *
     * @returns "true" if selection is supported.
     */
    private _isSelectionSupported;
    /**
     * Sets checked value.
     *
     * @param checked Checked.
     */
    private _setChecked;
}
//# sourceMappingURL=HTMLInputElement.d.ts.map