import IWindow from '../../window/IWindow.cjs';
import Event from '../Event.cjs';
import IMessagePort from '../IMessagePort.cjs';
import IMessageEventInit from './IMessageEventInit.cjs';
/**
 * Message event.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/MessageEvent
 */
export default class MessageEvent extends Event {
    data?: unknown | null;
    origin?: string;
    lastEventId?: string;
    source?: IWindow | null;
    ports?: IMessagePort[];
    /**
     * Constructor.
     *
     * @param type Event type.
     * @param [eventInit] Event init.
     */
    constructor(type: string, eventInit?: IMessageEventInit);
}
//# sourceMappingURL=MessageEvent.d.ts.map