"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./types");
describe("isValidEntity", () => {
    it("should work with numbers", () => {
        expect((0, types_1.isValidEntity)(5)).toBe(true);
        expect((0, types_1.isValidEntity)({ a: 5 })).toBe(true);
    });
    it("should work with strings", () => {
        expect((0, types_1.isValidEntity)("abc")).toBe(true);
        expect((0, types_1.isValidEntity)({ a: "abc" })).toBe(true);
    });
    it("should work with Dates", () => {
        expect((0, types_1.isValidEntity)(new Date())).toBe(true);
        expect((0, types_1.isValidEntity)({ a: new Date() })).toBe(true);
    });
    it("should work with BigInts", () => {
        expect((0, types_1.isValidEntity)(BigInt(123))).toBe(true);
        expect((0, types_1.isValidEntity)({ a: BigInt(123) })).toBe(true);
    });
    it("should not work with Symbols", () => {
        expect((0, types_1.isValidEntity)(Symbol("hi"))).toBe(false);
        expect((0, types_1.isValidEntity)({ a: Symbol("hi") })).toBe(false);
    });
    it("should not work with functions", () => {
        expect((0, types_1.isValidEntity)(() => { })).toBe(false);
        expect((0, types_1.isValidEntity)({ a: () => { } })).toBe(false);
    });
    it("should work with objects", () => {
        expect((0, types_1.isValidEntity)({
            a: {
                e: new Date(),
                b: {
                    c: {
                        d: Symbol(),
                    },
                },
            },
        })).toBe(false);
    });
});
