"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidEntity = exports.isOrdinal = void 0;
function isOrdinal(val) {
    const t = typeof val;
    return (t === "string" ||
        t === "number" ||
        t === "bigint" ||
        val === null ||
        val === undefined ||
        val instanceof Date);
}
exports.isOrdinal = isOrdinal;
/**
 * Returns true if the given object is a valid entity.
 *
 * @example
 * assert(isValidEntity({ a: "" }) === true);
 * assert(isValidEntity({ b: () => {} }) === false);
 */
const isValidEntity = (obj) => {
    if (typeof obj === "function")
        return false;
    if (typeof obj === "symbol")
        return false;
    if (obj instanceof Date)
        return true;
    if (typeof obj === "bigint")
        return true;
    if (typeof obj === "object") {
        for (const key in obj) {
            if (!(0, exports.isValidEntity)(obj[key]))
                return false;
        }
        return true;
    }
    return true;
};
exports.isValidEntity = isValidEntity;
