import { Table } from "../../core";
import { Entity, PrimaryKeyOf } from "../../types";
import { SelectResult } from "../select/types";
import { Sort } from "../types";
/**
 * @returns all items from `items` sorted according to the given `sort` object.
 */
export declare function sortItems<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, items: T[], sort: Sort<T>, selectResult?: SelectResult<T>): T[];
/**
 * Returns a comparison function that can be used to sort a list according to a sort query.
 */
export declare function sortWithSortQuery<T>(sort: Sort<T>): (a: T, b: T) => number;
/**
 * Inserts `item` into `arr` which is assumed to be sorted with `sort`.
 */
export declare function insertIntoSortedList<T>(arr: T[], item: T, sort: Sort<T>): void;
