"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForOr = void 0;
const core_1 = require("../../core");
const and_1 = require("../analyze/and");
const where_1 = require("../analyze/where");
const and_2 = require("./and");
const where_2 = require("./where");
/**
 * Select all items for `filter`.
 *
 * @returns the selected items from the database, or `null` in case a full table scan is required.
 */
function selectForOr(table, or, cb, from) {
    if (or.OR.length === 0) {
        return { fullTableScan: false };
    }
    // If any of the queries require a full table scan, do a full table scan
    for (const filter of or.OR) {
        const complexity = "AND" in filter
            ? (0, and_1.analyzeAnd)(table, filter, from)
            : (0, where_1.analyzeWhere)(table, filter, from);
        if (complexity === Number.MAX_SAFE_INTEGER) {
            table[core_1.BlinkKey].storage.primary.valuesArray().forEach((v) => cb(v));
            return { fullTableScan: true };
        }
    }
    // Otherwise, emit for every item once
    let itemsMap = new Map();
    const selectResult = { rowsScanned: [], fullTableScan: false };
    for (const filter of or.OR) {
        const childCb = (item) => {
            const primaryKeyProperty = table[core_1.BlinkKey].options.primary;
            const primaryKey = item[primaryKeyProperty];
            itemsMap.set(primaryKey, item);
        };
        const result = "AND" in filter
            ? (0, and_2.selectForAnd)(table, filter, childCb, from)
            : (0, where_2.selectForWhere)(table, filter, childCb, from);
        if (result.rowsScanned) {
            selectResult.rowsScanned.push(...result.rowsScanned);
        }
    }
    itemsMap.forEach((val) => cb(val));
    return selectResult;
}
exports.selectForOr = selectForOr;
