"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForLte = void 0;
function selectForLte(btree, matcher, cb, from) {
    const minKey = from !== null && from !== void 0 ? from : btree.minKey();
    const maxKey = matcher.lte;
    if (minKey !== undefined) {
        btree.editRange(minKey, maxKey, true, (_, v) => {
            const ret = cb(v);
            if (ret === null || ret === void 0 ? void 0 : ret.cancel)
                return { break: 0 };
        });
    }
}
exports.selectForLte = selectForLte;
