"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForLt = void 0;
function selectForLt(btree, matcher, cb, from) {
    const minKey = from !== null && from !== void 0 ? from : btree.minKey();
    const maxKey = matcher.lt;
    if (minKey !== undefined) {
        btree.editRange(minKey, maxKey, false, (_, v) => {
            const ret = cb(v);
            if (ret === null || ret === void 0 ? void 0 : ret.cancel)
                return { break: 0 };
        });
    }
}
exports.selectForLt = selectForLt;
