"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForMatcher = void 0;
const between_1 = require("./between");
const eq_1 = require("./eq");
const gt_1 = require("./gt");
const gte_1 = require("./gte");
const in_1 = require("./in");
const lt_1 = require("./lt");
const lte_1 = require("./lte");
/**
 * Selects all items from `btree` that could possibly match the given `matcher`.
 */
function selectForMatcher(btree, matcher, cb, from) {
    if (matcher === null)
        return;
    if (typeof matcher === "object") {
        if ("gt" in matcher) {
            return (0, gt_1.selectForGt)(btree, matcher, cb, from);
        }
        else if ("gte" in matcher) {
            return (0, gte_1.selectForGte)(btree, matcher, cb, from);
        }
        else if ("lt" in matcher) {
            return (0, lt_1.selectForLt)(btree, matcher, cb, from);
        }
        else if ("lte" in matcher) {
            return (0, lte_1.selectForLte)(btree, matcher, cb, from);
        }
        else if ("between" in matcher) {
            return (0, between_1.selectForBetween)(btree, matcher, cb, from);
        }
        else if ("eq" in matcher) {
            return (0, eq_1.selectForEq)(btree, matcher.eq, cb, from);
        }
        else if ("in" in matcher) {
            return (0, in_1.selectForIn)(btree, matcher, cb, from);
        }
    }
    return (0, eq_1.selectForEq)(btree, matcher, cb, from);
}
exports.selectForMatcher = selectForMatcher;
