"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForIn = void 0;
const fast_deep_equal_1 = __importDefault(require("fast-deep-equal"));
const sorted_btree_1 = require("sorted-btree");
const compare_1 = require("../../compare");
const eq_1 = require("./eq");
function selectForIn(btree, matcher, cb, from) {
    if (matcher.in.length === 1) {
        return (0, eq_1.selectForEq)(btree, matcher.in[0], cb, from);
    }
    const matcherItems = getSortedMatcherItems(matcher);
    let minKey = matcherItems[0];
    minKey = from ? (0, compare_1.getBiggerKey)(minKey, from) : minKey;
    const maxKey = matcherItems[matcherItems.length - 1];
    btree.editRange(minKey, maxKey, true, (key, val) => {
        if ((0, fast_deep_equal_1.default)(key, minKey) || (0, fast_deep_equal_1.default)(key, maxKey) || matcherItems.includes(key)) {
            const ret = cb(val);
            if (ret === null || ret === void 0 ? void 0 : ret.cancel)
                return { break: 0 };
        }
    });
}
exports.selectForIn = selectForIn;
function getSortedMatcherItems(matcher) {
    const items = [...matcher.in];
    if (typeof items[0] === "number" ||
        typeof items[0] === "string" ||
        items[0] instanceof Date) {
        items.sort(sorted_btree_1.defaultComparator);
    }
    else {
        items.sort();
    }
    return items;
}
