"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForGte = void 0;
const compare_1 = require("../../compare");
function selectForGte(btree, matcher, cb, from) {
    let minKey = matcher.gte;
    minKey = from ? (0, compare_1.getBiggerKey)(minKey, from) : minKey;
    const maxKey = btree.maxKey();
    if (maxKey !== undefined) {
        btree.editRange(minKey, maxKey, true, (_, v) => {
            const ret = cb(v);
            if (ret === null || ret === void 0 ? void 0 : ret.cancel)
                return { break: 0 };
        });
    }
}
exports.selectForGte = selectForGte;
