"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForGt = void 0;
const compare_1 = require("../../compare");
function selectForGt(btree, matcher, cb, from) {
    let minKey = matcher.gt;
    minKey = from ? (0, compare_1.getBiggerKey)(minKey, from) : minKey;
    const maxKey = btree.maxKey();
    if (maxKey !== undefined) {
        btree.editRange(minKey, maxKey, true, (k, v) => {
            if (k !== minKey) {
                const ret = cb(v);
                if (ret === null || ret === void 0 ? void 0 : ret.cancel)
                    return { break: 0 };
            }
        });
    }
}
exports.selectForGt = selectForGt;
