"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForBetween = void 0;
const compare_1 = require("../../compare");
function selectForBetween(btree, matcher, cb, from) {
    let minKey = matcher.between[0];
    minKey = from ? (0, compare_1.getBiggerKey)(minKey, from) : minKey;
    const maxKey = matcher.between[1];
    btree.editRange(minKey, maxKey, true, (_, v) => {
        const ret = cb(v);
        if (ret === null || ret === void 0 ? void 0 : ret.cancel)
            return { break: 0 };
    });
}
exports.selectForBetween = selectForBetween;
