"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.select = void 0;
const and_1 = require("./and");
const or_1 = require("./or");
const where_1 = require("./where");
/**
 * Select all items for `filter`.
 *
 * @returns the selected items from the database, or `null` in case a full table scan is required.
 */
function select(table, where, cb, from) {
    if ("AND" in where) {
        return (0, and_1.selectForAnd)(table, where, cb, from);
    }
    else if ("OR" in where) {
        return (0, or_1.selectForOr)(table, where, cb, from);
    }
    else {
        return (0, where_1.selectForWhere)(table, where, cb, from);
    }
}
exports.select = select;
