import { Table } from "../../core";
import { Entity, PrimaryKeyOf } from "../../types";
import { And, Or, Where } from "../types";
import { SelectCallback, SelectResult } from "./types";
/**
 * Select all items for `filter`.
 *
 * @returns the selected items from the database, or `null` in case a full table scan is required.
 */
export declare function select<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, where: Where<T> | Or<T> | And<T>, cb: SelectCallback<T>, from?: T[P]): SelectResult<T>;
