"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.selectForAnd = void 0;
const or_1 = require("../analyze/or");
const where_1 = require("../analyze/where");
const or_2 = require("./or");
const where_2 = require("./where");
/**
 * Select all items for `filter`.
 *
 * @returns the selected items from the database, or `null` in case a full table scan is required.
 */
function selectForAnd(table, and, cb, from) {
    if (and.AND.length === 0) {
        return { fullTableScan: false };
    }
    let minComplexity = Number.MAX_SAFE_INTEGER;
    let bestFilter = and.AND[0];
    for (const filter of and.AND) {
        const complexity = "OR" in filter ? (0, or_1.analyzeOr)(table, filter, from) : (0, where_1.analyzeWhere)(table, filter, from);
        if (complexity < minComplexity) {
            minComplexity = complexity;
            bestFilter = filter;
        }
    }
    return "OR" in bestFilter
        ? (0, or_2.selectForOr)(table, bestFilter, cb, from)
        : (0, where_2.selectForWhere)(table, bestFilter, cb, from);
}
exports.selectForAnd = selectForAnd;
