"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.limitItems = void 0;
const core_1 = require("../../core");
const compare_1 = require("../compare");
/**
 * @returns all items from `items` limited according to the given `limit` object.
 */
function limitItems(table, items, limit, skipFromStep = false) {
    if (items.length === 0) {
        return [];
    }
    const primaryKeyProperty = table[core_1.BlinkKey].options.primary;
    let fromIndex = 0;
    let toIndex = items.length;
    if (!skipFromStep && limit.from !== undefined) {
        fromIndex = items.findIndex((item) => (0, compare_1.compare)(item[primaryKeyProperty], limit.from) >= 0);
    }
    if (limit.skip !== undefined) {
        fromIndex += limit.skip;
    }
    if (limit.take !== undefined) {
        toIndex = Math.min(fromIndex + limit.take, toIndex);
    }
    if (fromIndex === 0 && toIndex === items.length) {
        return items;
    }
    return items.slice(fromIndex, toIndex);
}
exports.limitItems = limitItems;
