"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.get = void 0;
const core_1 = require("../core");
const filter_1 = require("./filter");
const limit_1 = require("./limit");
const select_1 = require("./select");
const sort_1 = require("./sort");
/**
 * retrieve all items matching the given `filter`.
 */
function get(table, filter) {
    var _a, _b;
    let skipFromStep = false;
    let items = [];
    let selectResult;
    // Retrieve items
    if (filter.where) {
        selectResult = (0, select_1.select)(table, filter.where, (item) => {
            if ((0, filter_1.matches)(item, filter.where)) {
                items.push(item);
            }
        }, (_a = filter.limit) === null || _a === void 0 ? void 0 : _a.from);
    }
    else {
        const btree = table[core_1.BlinkKey].storage.primary;
        if ((_b = filter.limit) === null || _b === void 0 ? void 0 : _b.from) {
            const maxKey = btree.maxKey();
            if (maxKey) {
                btree.forRange(filter.limit.from, maxKey, true, (_, item) => {
                    items.push(item);
                });
                skipFromStep = true;
            }
            selectResult = {
                rowsScanned: [table[core_1.BlinkKey].options.primary],
                fullTableScan: false,
            };
        }
        else {
            items = table[core_1.BlinkKey].storage.primary.valuesArray();
            selectResult = {
                rowsScanned: [table[core_1.BlinkKey].options.primary],
                fullTableScan: false,
            };
        }
    }
    // Sort items
    if (filter.sort) {
        items = (0, sort_1.sortItems)(table, items, filter.sort, selectResult);
    }
    // Limit items
    if (filter.limit) {
        items = (0, limit_1.limitItems)(table, items, filter.limit, skipFromStep);
    }
    return items;
}
exports.get = get;
