"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchesWhere = void 0;
const matchers_1 = require("./matchers");
/**
 * @returns whether the given `item` matches all matchers in `where`.
 */
function matchesWhere(item, where) {
    for (const property in where) {
        const matcher = where[property];
        if (matcher !== undefined &&
            matcher !== null &&
            !(0, matchers_1.matches)(item[property], matcher)) {
            return false;
        }
    }
    return true;
}
exports.matchesWhere = matchesWhere;
