"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchesOr = void 0;
const and_1 = require("./and");
const where_1 = require("./where");
/**
 * @returns whether the given `item` matches `or`.
 */
function matchesOr(item, or) {
    if (or.OR.length === 0)
        return true;
    for (const childFilter of or.OR) {
        const matches = "AND" in childFilter
            ? (0, and_1.matchesAnd)(item, childFilter)
            : (0, where_1.matchesWhere)(item, childFilter);
        if (matches) {
            return true;
        }
    }
    return false;
}
exports.matchesOr = matchesOr;
