"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matches = void 0;
const between_1 = require("./between");
const contains_1 = require("./contains");
const eq_1 = require("./eq");
const gt_1 = require("./gt");
const gte_1 = require("./gte");
const in_1 = require("./in");
const lt_1 = require("./lt");
const lte_1 = require("./lte");
const sub_1 = require("./sub");
/**
 * @returns whether `property` matches `matcher`.
 */
function matches(value, matcher) {
    if (matcher === null)
        return false;
    // `any` here prevents TS complaining from generating an union type too complex to represent
    if (matcher instanceof Date && value instanceof Date) {
        return (0, eq_1.matchesEq)(value, matcher);
    }
    else if (typeof matcher === "object") {
        if ("gte" in matcher) {
            return (0, gte_1.matchesGte)(value, matcher);
        }
        else if ("gt" in matcher) {
            return (0, gt_1.matchesGt)(value, matcher);
        }
        else if ("lte" in matcher) {
            return (0, lte_1.matchesLte)(value, matcher);
        }
        else if ("lt" in matcher) {
            return (0, lt_1.matchesLt)(value, matcher);
        }
        else if ("eq" in matcher) {
            return (0, eq_1.matchesEq)(value, matcher.eq);
        }
        else if ("in" in matcher) {
            return (0, in_1.matchesIn)(value, matcher);
        }
        else if ("contains" in matcher) {
            return (0, contains_1.matchesContains)(value, matcher);
        }
        else if ("between" in matcher) {
            return (0, between_1.matchesBetween)(value, matcher);
        }
        else if ("where" in matcher) {
            return (0, sub_1.matchesSubWhere)(value, matcher);
        }
    }
    return (0, eq_1.matchesEq)(value, matcher);
}
exports.matches = matches;
