"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchesEq = void 0;
const fast_deep_equal_1 = __importDefault(require("fast-deep-equal"));
function matchesEq(value, matcher) {
    if (value instanceof Date && matcher instanceof Date) {
        return value.getTime() === matcher.getTime();
    }
    let newVal = value;
    let newMatcher = matcher;
    if (Array.isArray(value)) {
        newVal = [...value].sort();
    }
    if (Array.isArray(matcher)) {
        newMatcher = [...matcher].sort();
    }
    return (0, fast_deep_equal_1.default)(newVal, newMatcher);
}
exports.matchesEq = matchesEq;
