"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matches = void 0;
const and_1 = require("./and");
const or_1 = require("./or");
const where_1 = require("./where");
/**
 * @returns whether the given `item` matches the filter.
 */
function matches(item, filter) {
    if ("AND" in filter) {
        return (0, and_1.matchesAnd)(item, filter);
    }
    else if ("OR" in filter) {
        return (0, or_1.matchesOr)(item, filter);
    }
    else {
        return (0, where_1.matchesWhere)(item, filter);
    }
}
exports.matches = matches;
