"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchesAnd = void 0;
const or_1 = require("./or");
const where_1 = require("./where");
/**
 * @returns whether the given `item` matches `and`.
 */
function matchesAnd(item, and) {
    for (const childFilter of and.AND) {
        const matches = "OR" in childFilter
            ? (0, or_1.matchesOr)(item, childFilter)
            : (0, where_1.matchesWhere)(item, childFilter);
        if (!matches) {
            return false;
        }
    }
    return true;
}
exports.matchesAnd = matchesAnd;
