"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBiggerKey = exports.compare = void 0;
const sorted_btree_1 = require("sorted-btree");
function compare(a, b) {
    if (typeof a === "bigint" && typeof b === "bigint") {
        return a - b;
    }
    return (0, sorted_btree_1.defaultComparator)(a, b);
}
exports.compare = compare;
function getBiggerKey(a, b) {
    return compare(a, b) >= 0 ? a : b;
}
exports.getBiggerKey = getBiggerKey;
