"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzeWhere = void 0;
const core_1 = require("../../core");
const matchers_1 = require("./matchers");
function analyzeWhere(table, where, from) {
    if (Object.keys(where).length === 0)
        return 0;
    let primaryKeyProperty = table[core_1.BlinkKey].options.primary;
    let minComplexity = Number.MAX_SAFE_INTEGER;
    for (const key in where) {
        const matcher = where[key];
        let complexity;
        if (key === primaryKeyProperty) {
            const btree = table[core_1.BlinkKey].storage.primary;
            complexity = (0, matchers_1.analyzeMatcher)(btree, matcher, from);
        }
        else {
            const btree = table[core_1.BlinkKey].storage.indexes[key];
            if (btree) {
                const matcherComplexity = (0, matchers_1.analyzeMatcher)(btree, matcher);
                const itemsPerNode = btree.totalItemSize / btree.size;
                complexity = Math.round(matcherComplexity * itemsPerNode);
            }
        }
        if (complexity && complexity < minComplexity) {
            minComplexity = complexity;
        }
    }
    return minComplexity;
}
exports.analyzeWhere = analyzeWhere;
