"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzeOr = void 0;
const and_1 = require("./and");
const where_1 = require("./where");
function analyzeOr(table, or, from) {
    let complexity = 0;
    for (const key in or.OR) {
        const filter = or.OR[key];
        const filterComplexity = "AND" in filter
            ? (0, and_1.analyzeAnd)(table, filter, from)
            : (0, where_1.analyzeWhere)(table, filter, from);
        complexity += filterComplexity;
    }
    return complexity;
}
exports.analyzeOr = analyzeOr;
