"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyze = void 0;
const and_1 = require("./and");
const or_1 = require("./or");
const where_1 = require("./where");
/**
 * @returns the theoretical complexity of a given filter.
 */
function analyze(table, filter, from) {
    if ("AND" in filter) {
        return (0, and_1.analyzeAnd)(table, filter, from);
    }
    else if ("OR" in filter) {
        return (0, or_1.analyzeOr)(table, filter, from);
    }
    else {
        return (0, where_1.analyzeWhere)(table, filter, from);
    }
}
exports.analyze = analyze;
