"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzeAnd = void 0;
const or_1 = require("./or");
const where_1 = require("./where");
function analyzeAnd(table, and, from) {
    let minComplexity = Number.MAX_SAFE_INTEGER;
    if (and.AND.length === 0)
        return 0;
    for (const key in and.AND) {
        const filter = and.AND[key];
        const filterComplexity = "OR" in filter ? (0, or_1.analyzeOr)(table, filter, from) : (0, where_1.analyzeWhere)(table, filter, from);
        if (filterComplexity < minComplexity) {
            minComplexity = filterComplexity;
        }
    }
    return minComplexity;
}
exports.analyzeAnd = analyzeAnd;
