"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.middleware = void 0;
const core_1 = require("../core");
function middleware(hooksOrTable, context, impl) {
    let contextTable = context.table;
    let hooks;
    if (Array.isArray(hooksOrTable)) {
        hooks = hooksOrTable;
    }
    else {
        const table = hooksOrTable;
        const dbHooks = table[core_1.BlinkKey].db[core_1.BlinkKey].hooks;
        const tableHooks = table[core_1.BlinkKey].hooks;
        hooks = [...dbHooks, ...tableHooks];
        contextTable = table[core_1.BlinkKey].tableName;
    }
    return executeHook(hooks, Object.assign(Object.assign({}, context), { table: contextTable }), impl);
}
exports.middleware = middleware;
function executeHook(hooks, context, impl) {
    const [step, ...next] = hooks;
    return step
        ? step(Object.assign(Object.assign({}, context), { next: (...args) => executeHook(next, Object.assign(Object.assign({}, context), { params: args }), impl) }))
        : impl(...context.params);
}
