"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dispatcher = void 0;
/**
 * Allows registering multiple callbacks
 * and calling all of them at the same time.
 */
class Dispatcher {
    constructor() {
        this.callbacks = new Set();
    }
    /**
     * register a function to be called when the event emits.
     *
     * @returns a function that can be called to remove the registered callback.
     */
    register(cb) {
        this.callbacks.add(cb);
        return () => {
            this.callbacks.delete(cb);
        };
    }
    /**
     * call all registered callbacks with the provided data.
     */
    dispatch(data) {
        return __awaiter(this, void 0, void 0, function* () {
            this.callbacks.forEach((cb) => cb(data));
        });
    }
    /**
     * Returns true if this dispatcher has listeners.
     * If this returns false, then you can skip calling `dispatch` for performance optimizations.
     */
    hasListeners() {
        return this.callbacks.size > 0;
    }
}
exports.Dispatcher = Dispatcher;
