/**
 * Allows registering multiple callbacks
 * and calling all of them at the same time.
 */
export declare class Dispatcher<T = void> {
    private callbacks;
    /**
     * register a function to be called when the event emits.
     *
     * @returns a function that can be called to remove the registered callback.
     */
    register(cb: Callback<T>): () => void;
    /**
     * call all registered callbacks with the provided data.
     */
    dispatch(data: T): Promise<void>;
    /**
     * Returns true if this dispatcher has listeners.
     * If this returns false, then you can skip calling `dispatch` for performance optimizations.
     */
    hasListeners(): boolean;
}
declare type Callback<T> = (data: T) => Promise<void> | void;
export {};
