"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uuid = void 0;
const hyperid_1 = __importDefault(require("hyperid"));
const instance = (0, hyperid_1.default)();
/**
 * Returns a unique uuid. You can use this as the primary key for entities.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const aliceId = insert(userTable, { id: uuid(), name: "Alice", age: 23 });
 */
function uuid() {
    return instance();
}
exports.uuid = uuid;
