"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAction = exports.use = void 0;
const createDB_1 = require("./createDB");
function use(obj, hook) {
    const index = obj[createDB_1.BlinkKey].hooks.push(hook);
    return () => obj[createDB_1.BlinkKey].hooks.splice(index, 1);
}
exports.use = use;
/**
 * Helper method for returns if the hook was called because of a given action.
 * This will also cast the given context so that `ctx.params` & `ctx.next()` are typed correctly.
 *
 * @example
 * const db = createDB();
 * // `console.log` every time an item is inserted
 * use(db, (ctx) => {
 *   if(isAction(ctx, "insert") || isAction(ctx, "insertMany")) {
 *     console.log("Inserting items:", ctx.params);
 *   }
 *   return ctx.next(...ctx.params);
 * });
 */
function isAction(ctx, action) {
    return ctx.action === action;
}
exports.isAction = isAction;
