import { Entity, PrimaryKeyOf } from "../types";
import { Table } from "./createTable";
/**
 * For each given entity of `entities`, either updates the entity if it exists,
 * or inserts it into the table if it doesn't.
 *
 * @returns the primary key of the inserted/updated entities,
 * in the same order as the items.
 *
 * @example
 * const db = createDB();
 * const userTable = createTable<User>(db, "users")();
 * const aliceId = await insert(userTable, { id: uuid(), name: 'Alice', age: 15 });
 * // Increase the age of Alice & insert a new user
 * await upsertMany(userTable, [
 *   { id: aliceId, age: 16 },
 *   { id: uuid(), age: 45 }
 * ]);
 */
export declare function upsertMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entities: T[]): Promise<T[P][]>;
export declare function internalUpsertMany<T extends Entity<T>, P extends PrimaryKeyOf<T>>(table: Table<T, P>, entities: T[]): Promise<T[P][]>;
